package kom.itbeankit.common;

import java.beans.*;
import java.beans.SimpleBeanInfo;
import symantec.itools.beans.*;

public class ItBeanBeanInfo extends java.beans.SimpleBeanInfo
{
	public ItBeanBeanInfo()
	{
	}

	/**
	 * Gets a BeanInfo for the superclass of this bean.
	 * @return BeanInfo[] containing this bean's superclass BeanInfo
	 */
	public BeanInfo[] getAdditionalBeanInfo()
	{
		try
		{
			BeanInfo[] bi = new BeanInfo[1];
			bi[0] = Introspector.getBeanInfo(beanClass.getSuperclass());
			return bi;
		}
		catch (IntrospectionException e)
		{
			throw new Error(e.toString());
		}
	}

	/**
	* Gets the SymantecBeanDescriptor for this bean.
	* @return an object of type SymantecBeanDescriptor
	* @see symantec.itools.beans.SymantecBeanDescriptor
	*/
	public BeanDescriptor getBeanDescriptor()
	{
		BeanDescriptor bd = new BeanDescriptor(beanClass);
		return bd;
	}

	/**
	 * Gets an image that may be used to visually represent this bean
	 * (in the toolbar, on a form, etc).
	 * @param iconKind the type of icon desired, one of: BeanInfo.ICON_MONO_16x16,
	 * BeanInfo.ICON_COLOR_16x16, BeanInfo.ICON_MONO_32x32, or BeanInfo.ICON_COLOR_32x32.
	 * @return an image for this bean
	 * @see BeanInfo#ICON_MONO_16x16
	 * @see BeanInfo#ICON_COLOR_16x16
	 * @see BeanInfo#ICON_MONO_32x32
	 * @see BeanInfo#ICON_COLOR_32x32
	 */
	public java.awt.Image getIcon(int nIconKind)
	{
		java.awt.Image img = null;
		if (nIconKind == BeanInfo.ICON_COLOR_16x16)
				img = loadImage("beandummy1Icon.gif");
		if (nIconKind == BeanInfo.ICON_COLOR_32x32)
			img = loadImage("beandummy1Icon.gif");
		return img;
	}

	/**
	 * Returns descriptions of this bean's properties.
	 */
	public PropertyDescriptor[] getPropertyDescriptors()
	{
		try{
			PropertyDescriptor userLevelComplexity = new PropertyDescriptor("userLevelComplexity",beanClass, "getUserLevelComplexity","setUserLevelComplexity");
			PropertyDescriptor pins = new PropertyDescriptor("pins",beanClass, "getPins","setPins");
			PropertyDescriptor freeRunning = new PropertyDescriptor("freeRunning",beanClass, "isFreeRunning","setFreeRunning");
			PropertyDescriptor first = new PropertyDescriptor("first",beanClass, "first","setFirst");
			PropertyDescriptor last = new PropertyDescriptor("last",beanClass, "last","setLast");
			PropertyDescriptor connected = new PropertyDescriptor("isConnected",beanClass, "isConnected","setConnected");
			PropertyDescriptor beanNumber = new PropertyDescriptor("beanNumber",beanClass, "getBeanNumber","setBeanNumber");
			PropertyDescriptor pool = new PropertyDescriptor("pool",beanClass, "getPool","setPool");
			PropertyDescriptor iterationNumber = new PropertyDescriptor("iterationNumber",beanClass, "getIterationNumber","setIterationNumber");
			PropertyDescriptor[] rv = {
				userLevelComplexity
				,pins
				,freeRunning
				,first
				,last
				,connected
				,beanNumber
				,pool
				,iterationNumber
			};
			return rv;
		}
		catch (IntrospectionException e)
		{
			throw new Error(e.toString());
		}
	}

	private final static Class beanClass = ItBean.class;
}